#ifndef BM_UTILS_H
#define BM_UTILS_H

#include <Std_Types.h>

#ifdef APP_ID
#undef APP_ID
#endif

#define APP_ID Thermal_system_full

/* Macros to directly concatenate values. 
 * Due to the macro expansion these macros can only be used to expand literals. */
#define RAW_CONCAT_2(A, B) A##_##B
#define RAW_CONCAT_3(A, B, C) A##_##B##_##C
 
/* Indirect macros which can be used to concatenate macros */
#define CONCAT_2(A, B) RAW_CONCAT_2(A, B)
#define CONCAT_3(A, B, C) RAW_CONCAT_3(A, B, C)

#define APP_UNIQUE(Name) CONCAT_2(APP_ID, Name)

#define ASPECT_UNIQUE(name) CONCAT_3(BUS_CONFIGURATION_ID, ECU_ID, name)

#if defined(MAX)
#undef MAX
#endif
#define MAX(x, y) ((x) > (y) ? (x) : (y))

#if defined(MIN)
#undef MIN
#endif
#define MIN(x, y) ((x) < (y) ? (x) : (y))


#ifdef __GNUC__
#define UNUSED __attribute__ ((unused))
#else 
#define UNUSED 
#endif

#if defined(MIN)
#undef MIN
#endif
#if defined(MAX)
#undef MAX
#endif

#define MIN(x, y) ((x) < (y) ? (x) : (y))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

#ifndef INTENDED_UNREFERENCED_PARAMETER
#define INTENDED_UNREFERENCED_PARAMETER(x) (void)x
#endif

#ifndef POSSIBLE_UNREFERENCED_PARAMETER
#define POSSIBLE_UNREFERENCED_PARAMETER(x) (void)x
#endif

#if defined(EXTERN_C_DECL)
#undef EXTERN_C_DECL
#endif
#if defined(__cplusplus)
#define EXTERN_C_DECL extern "C"
/* ScalingFunctions.h */

#else
#define EXTERN_C_DECL extern
#endif

/* Void pointer to zero. */
#ifndef NULL_PTR
#define NULL_PTR ((void *)0)
#endif

/* Generic functionality */
#define GenericCompareFunction APP_UNIQUE(GenericCompareFunction)
typedef int(*GenericCompareFunction)(void* a, void* b);
#define GENERIC_COMPARE_FUNCTION(functionName, type, logic) \
    static int functionName(void* ptrA, void* ptrB) { \
        type* a = (type*)ptrA; \
        type* b = (type*)ptrB; \
        logic; \
    }

/* Submodule redefines */
/* ScalingFunctions.h */
#define Scale_Linear_From_boolean APP_UNIQUE(Scale_Linear_From_boolean)
#define Scale_Linear_From_boolean_noround APP_UNIQUE(Scale_Linear_From_boolean_noround)
#define roundSource_From_boolean APP_UNIQUE(roundSource_From_boolean)
#define Scale_Linear_From_sint8 APP_UNIQUE(Scale_Linear_From_sint8)
#define Scale_Linear_From_sint8_noround APP_UNIQUE(Scale_Linear_From_sint8_noround)
#define roundSource_From_sint8 APP_UNIQUE(roundSource_From_sint8)
#define Scale_Linear_From_uint8 APP_UNIQUE(Scale_Linear_From_uint8)
#define Scale_Linear_From_uint8_noround APP_UNIQUE(Scale_Linear_From_uint8_noround)
#define roundSource_From_uint8 APP_UNIQUE(roundSource_From_uint8)
#define Scale_Linear_From_sint16 APP_UNIQUE(Scale_Linear_From_sint16)
#define Scale_Linear_From_sint16_noround APP_UNIQUE(Scale_Linear_From_sint16_noround)
#define roundSource_From_sint16 APP_UNIQUE(roundSource_From_sint16)
#define Scale_Linear_From_uint16 APP_UNIQUE(Scale_Linear_From_uint16)
#define Scale_Linear_From_uint16_noround APP_UNIQUE(Scale_Linear_From_uint16_noround)
#define roundSource_From_uint16 APP_UNIQUE(roundSource_From_uint16)
#define Scale_Linear_From_sint32 APP_UNIQUE(Scale_Linear_From_sint32)
#define Scale_Linear_From_sint32_noround APP_UNIQUE(Scale_Linear_From_sint32_noround)
#define roundSource_From_sint32 APP_UNIQUE(roundSource_From_sint32)
#define Scale_Linear_From_uint32 APP_UNIQUE(Scale_Linear_From_uint32)
#define Scale_Linear_From_uint32_noround APP_UNIQUE(Scale_Linear_From_uint32_noround)
#define roundSource_From_uint32 APP_UNIQUE(roundSource_From_uint32)
#define Scale_Linear_From_sint64 APP_UNIQUE(Scale_Linear_From_sint64)
#define Scale_Linear_From_sint64_noround APP_UNIQUE(Scale_Linear_From_sint64_noround)
#define roundSource_From_sint64 APP_UNIQUE(roundSource_From_sint64)
#define Scale_Linear_From_uint64 APP_UNIQUE(Scale_Linear_From_uint64)
#define Scale_Linear_From_uint64_noround APP_UNIQUE(Scale_Linear_From_uint64_noround)
#define roundSource_From_uint64 APP_UNIQUE(roundSource_From_uint64)
#define Scale_Linear_From_float32 APP_UNIQUE(Scale_Linear_From_float32)
#define Scale_Linear_From_float32_noround APP_UNIQUE(Scale_Linear_From_float32_noround)
#define roundSource_From_float32 APP_UNIQUE(roundSource_From_float32)
#define Scale_Linear_From_float64 APP_UNIQUE(Scale_Linear_From_float64)
#define Scale_Linear_From_float64_noround APP_UNIQUE(Scale_Linear_From_float64_noround)
#define roundSource_From_float64 APP_UNIQUE(roundSource_From_float64)
#define ClampSigned APP_UNIQUE(ClampSigned)
#define ClampUnsigned APP_UNIQUE(ClampUnsigned)
#define ClampSignedToUnsigned APP_UNIQUE(ClampSignedToUnsigned)
#define ClampUnsignedToSigned APP_UNIQUE(ClampUnsignedToSigned)
#define ClampFloat APP_UNIQUE(ClampFloat)


#define PDU_LENGTH_SIM_SUPPORT 0

typedef uint32 PduIdType;

/* Function pointer to send-out triggered PDU (ComTriggerIPDU) */
typedef Std_ReturnType (*PduSendFunction)(PduIdType);

/* Function pointer to check PDU enable state */
typedef boolean (*PduCheckEnableFunction)(PduIdType);

/* Enumeration of PDU pending states. Must be a power of two (0x01, 0x02, 0x04, 0x08, ...) */
typedef enum BUSCFG_TX_PENDING_ENUM {
    /* PDU is not triggered */
    E_PENDING_NONE    = 0x00,
    /* PDU was trigger due to cycle time */
    E_PENDING_CYCLIC  = 0x01,
    /* PDU was triggered manually */
    E_PENDING_MANUAL  = 0x02,
} BUSCFG_TX_PENDING_ENUM;

typedef struct {
    sint32  init_period;  /* PDU initial cyclic interval */
    sint32  period;       /* PDU runtime cyclic interval */
    sint32  init_offset;  /* PDU initial trigger offset */
    sint32  offset;       /* PDU runtime trigger offset */
    sint64  next_time;    /* Time value for next cyclic trigger */
} BusCfgTxPduTiming;

typedef struct {
    uint32  ComControllerStateIndex;      /* StateManager index of ComController enable */
    sint32  CreditsStateIndex;            /* StateManager index of credit counting */
    uint8   ControllerState;              /* Indicator for ComController state */
} BusCfgTxPduStates;

/* typedef of TX PDU */
typedef struct {
    PduSendFunction             ComTriggerIPDU;             /* Function pointer to Com_TriggerIPDU() */
    PduCheckEnableFunction      IsPduEnabled;               /* Function pointer to Check PDU enable state */
    BUSCFG_TX_PENDING_ENUM      pending;                    /* Flag indicates PDU request for send */
    BusCfgTxPduTiming           timing;                     /* PDU timing data */
    BusCfgTxPduStates           states;                     /* PDU state indexes */
} BusCfgTxPdu;

#endif /* BM_UTILS_H */

